<h1 class="mb-4">Upravit produkt</h1>

<form method="post" action="" class="needs-validation" novalidate>
    <div class="mb-3">
        <label for="name" class="form-label">Název:</label>
        <input id="name" name="name" type="text" class="form-control" value="<?= htmlspecialchars($product->name) ?>" required>
        <div class="invalid-feedback">
            Prosím, zadejte název produktu.
        </div>
    </div>

    <div class="mb-3">
        <label for="category" class="form-label">Kategorie:</label>
        <select id="category" name="category" class="form-select" required>
            <option value="ovoce" <?= ($product->category === 'ovoce') ? 'selected' : '' ?>>Ovoce</option>
            <option value="zelenina" <?= ($product->category === 'zelenina') ? 'selected' : '' ?>>Zelenina</option>
            <option value="orechy" <?= ($product->category === 'orechy') ? 'selected' : '' ?>>Ořechy</option>
        </select>
        <div class="invalid-feedback">
            Prosím, vyberte kategorii.
        </div>
    </div>

    <div class="mb-3">
        <label for="price" class="form-label">Cena (CZK):</label>
        <input id="price" name="price" type="number" class="form-control" step="0.01" value="<?= htmlspecialchars($product->price) ?>" required>
        <div class="invalid-feedback">
            Prosím, zadejte cenu.
        </div>
    </div>

    <div class="mb-3">
        <label for="stock" class="form-label">Sklad (ks):</label>
        <input id="stock" name="stock" type="number" class="form-control" value="<?= htmlspecialchars($product->stock) ?>" required>
        <div class="invalid-feedback">
            Prosím, zadejte počet kusů.
        </div>
    </div>

    <div class="mb-3">
        <label for="supplier_id" class="form-label">Dodavatel:</label>
        <select id="supplier_id" name="supplier_id" class="form-select">
            <option value="">-- bez dodavatele --</option>
            <?php foreach ($suppliers as $s): ?>
                <option value="<?= $s->id ?>" <?= ($product->supplier_id == $s->id) ? 'selected' : '' ?>><?= htmlspecialchars($s->name) ?></option>
            <?php endforeach; ?>
        </select>
    </div>

   <div class="d-flex justify-content-between mt-4">
        <button type="submit" class="btn btn-success"><i class="bi bi-check-lg"></i></button>
        <a href="?controller=product&action=index" class="btn btn-secondary"><i class="bi bi-arrow-left"></i></a>
    </div>
</form>

<script>
    (function() {
        'use strict'
        var forms = document.querySelectorAll('.needs-validation')

        Array.prototype.slice.call(forms)
        .forEach(function (form) {
            form.addEventListener('submit', function (event) {
                if (!form.checkValidity()) {
                    event.preventDefault()
                    event.stopPropagation()
                }
                form.classList.add('was-validated')
            }, false)
        })
    })()
</script>